/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FlickrUtil {

public static String[] getPhotosInfo(Object data) {
	try {
		Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader((String)data)));
		Node rsp = document.getFirstChild();
		if (rsp.getAttributes().getNamedItem("stat").getNodeValue().equals("ok")) {
			NodeList photosList = document.getElementsByTagName("photo");
			int length = photosList.getLength();
			String[] result = new String[length * 3];
			for (int i = 0, j = 0; i < length; i++) {
				Node photo = photosList.item(i);
				NamedNodeMap attrib = photo.getAttributes();
				result[j++] = attrib.getNamedItem("title").getNodeValue();
				result[j++] = attrib.getNamedItem("id").getNodeValue();
				result[j++] = attrib.getNamedItem("secret").getNodeValue();
			}
			return result;
		}
	} catch (SAXException e) {
		e.printStackTrace();
	} catch (IOException e) {
		e.printStackTrace();
	} catch (Exception e) {
		e.printStackTrace();
	}
	return null;
}

public static String getPhotoURL(Object data, String size) {
	try {
		Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader((String)data)));
		NodeList sizesList = document.getElementsByTagName("size");
		int length = sizesList.getLength();
		for (int i = 0; i < length; i++) {
			Node node = sizesList.item(i);
			String label = node.getAttributes().getNamedItem("label").getNodeValue(); 
			if (size.equals(label)) {
				return node.getAttributes().getNamedItem("source").getNodeValue();
			}
		}
	} catch (SAXException e) {
		e.printStackTrace();
	} catch (IOException e) {
		e.printStackTrace();
	} catch (Exception e) {
		e.printStackTrace();
	}
	return "";
}

public static void setImage(final Listener listener, final String url) {
	new Thread() {
		public void run() {
			InputStream in = null;
			try {
				URL urlcon = new URL(url);
				HttpURLConnection con = (HttpURLConnection) urlcon.openConnection();
				con.setRequestMethod("GET");
				con.setDoOutput(false);
				con.setDoInput(true);
				con.connect();
				in = con.getInputStream();
				Image image = new Image (Display.getCurrent(), in);
				final Event event = new Event();
				event.data = image;
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						listener.handleEvent(event);
					}
				});
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (in != null) in.close();
				} catch (Exception ex) {
				}		
			}
		}
	}.start();
}
}
